var express = require('express');
var app = express();
var server = require('http').Server(app);

// Port selection
var serverPort = 3200;
server.listen(serverPort);

// Public file serve
app.use(express.static(__dirname + '/public'));

// Main HTML
app.get('/', function (req, res) {
    res.type('text/html');
    res.sendfile('public/index.html');
});

// 404
app.use(function (req, res) {
    res.type('text/plain');
    res.status(404);
    res.send('404 - Not Found');
});

// 500
app.use(function (err, req, res, next) {
    console.error(err.stack);
    res.type('text/plain');
    res.status(500);
    res.send('500 - Server Error');
});

// Started Express server
process.stdout.write('Monitower listen on http://localhost:' + serverPort + '\n');

// Start SocketIO tranmitter
var fs = require('fs');
eval(fs.readFileSync(__dirname + '/lib/transmitter.js').toString());
