io = require('socket.io')(server);
fork = require('child_process').fork;

reg = {};                 // Global register
collector = {};           // Collector reference
dataSend = function(){};  // Sender shared function

// Socket.IO
io.sockets.on('connection', function (socket) {

  // DISCONNECT
  socket.on('disconnect', function () {
    process.stdout.write('SocketIO > Disconnected from ' + socket.conn.remoteAddress + '\n');
    if(io.engine.clientsCount < 1){
      process.stdout.write('No more client, killing Collector.js' + '\n');
      // Kill Collector if no more connected client
      collector.kill();
    }
  });

  // FIRST CONNECT
  if(io.engine.clientsCount == 1){
    // FUNCTION: Send DATA to all Socket.IO clients (broadcast)
    dataSend = function(stamp, data){
      socket.emit(stamp, data);
      socket.broadcast.emit(stamp, data);
    };
    process.stdout.write('SocketIO > Initial connection from ' + socket.conn.remoteAddress + '\n');
    process.stdout.write('Starting Collector.js' + '\n');
    // Start Collector.js with IPC channel
    collector = fork(__dirname + '/lib/collector.js',['-m', 'fork']);

  } else {
    process.stdout.write('SocketIO > Broadcasted connection from ' + socket.conn.remoteAddress + '\n');
    process.stdout.write('Client added to broadcast subscription' + '\n');
    // Send bufferd data
    for(cat in reg){
      for(item in reg[cat]){
        socket.emit(item, reg[cat][item]);
      }
    }
    return;
  }

  // COLLECTOR MESSAGES
  collector.on('message', function(data){

    switch(data[0]) {

      // GENERAL INFO -----------------------------------
      case 'info':
        reg.info = { 'info': data[1]};
        dataSend('info', reg.info.info);
      break;

      // LOAD AVERAGE ----------------------------------
      case 'loadavg':
        reg.loadavg = { 'loadavg': data[1]}
        dataSend('loadavg', reg.loadavg.loadavg);
      break;

      // UPTIME ----------------------------------------
      case 'uptime':
        reg.uptime = { 'uptime': data[1]};
        dataSend('uptime', reg.uptime.uptime);
      break;

      // CPU STATS --------------------------------------
      case 'cpu':
        coreNum = (data[1].CpuUsage.length-1);
        reg.cpu = {'cpuLoad': data[1].CpuUsage[coreNum],
          'coreGraph': {labels:[], series:[]}};
        for (var core = 0; core < coreNum; core++) {
          reg.cpu.coreGraph.labels.push(data[1].CpuFreq[core] + " MHz<br/>Core " + parseInt(core+1) );
          reg.cpu.coreGraph.series.push(data[1].CpuUsage[core]);
        }
        dataSend('cpuLoad', reg.cpu.cpuLoad);
        dataSend('coreGraph', reg.cpu.coreGraph);
      break;

      // MEMORY USAGE ----------------------------------
      case 'memory':
        reg.memory = { 'memoryGraph': {
          labels: [['RAM'], ['Swap']],
          series: [[data[1].MemFullUsage, 0], [data[1].MemUsage, data[1].SwapUsage]]
        }};
        dataSend('memoryGraph', reg.memory.memoryGraph);
      break;

      // NETWORK STATISTICS -----------------------------
      case 'network':
        if(! reg.network) {
          reg.network = { 'netGraph': { 'count': 15, 'values': {'label':[], 'down':[], 'up':[]} },
            'netConns': { 'tcp': 0, 'udp': 0 }};
          for (var count = 0; count < (reg.network.netGraph.count+1); count++) {
            reg.network.netGraph.values.down.push(0);
            reg.network.netGraph.values.up.push(0);
            reg.network.netGraph.values.label.push(count);
          }
        }
        reg.network.netGraph.values.down.shift();
        reg.network.netGraph.values.down.push(data[1].down);
        reg.network.netGraph.values.up.shift();
        reg.network.netGraph.values.up.push(data[1].up);

        dataSend('netGraph', {
          labels: reg.network.netGraph.values.label,
          series: [reg.network.netGraph.values.down, reg.network.netGraph.values.up]
        });

        reg.network.netConns = {'tcp':data[1].tcp, 'udp':data[1].udp};
        dataSend('netConns', reg.network.netConns);
      break;

      // STORAGE USAGE ------------------------------------
      case 'storage':

        reg.storage = {'diskGraph': {'labels': [], 'series': [[]]}};

        for(disk in data[1]){
          reg.storage.diskGraph.labels.push(data[1][disk].mount);
          reg.storage.diskGraph.series[0].push(data[1][disk].usage);
        }

        dataSend('diskGraph', {
            labels: reg.storage.diskGraph.labels,
            series: reg.storage.diskGraph.series
        });
      break;

      // CATCH OTHER MESSAGES ----------------------------
      default:
        process.stdout.write('Unknown message [' + data[0] + '] received from Collector...' + '\n');
      }
  });
});
