var socket = io();

socket.on('info', function(data){
    for (item in data) {
        div = document.getElementById(item);
        div.innerHTML = data[item];
    }
})

var uptime_div = document.getElementById("uptime");
socket.on('uptime', function(data) {
    uptime_data = data[0] + ' Hrs, ' + data[1] + ' Mins';
    uptime_div.innerHTML = uptime_data;
})

var loadavg_div = document.getElementById("loadavg");
socket.on('loadavg', function(data) {
    loadavg_data = '';
    for (var d in data) {
        loadavg_data += data[d] + ' '
    }
    loadavg_div.innerHTML = loadavg_data;
})

var memoryGraph, swapGraph;
var memoryGraph_opt= {
    high: 100,
    stackBars: true,
    seriesBarDistance: 1,
    height: 140,
    reverseData: true,
    horizontalBars: true,
    axisX: { showLabel: true,
        type: Chartist.FixedScaleAxis,
        onlyInteger: true,
        ticks: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
    },
    axisY: { offset: 55 }
};
socket.on('memoryGraph', function(data) {
    if (memoryGraph) {
        memoryGraph.update(data);
    } else {
        memoryGraph = new Chartist.Bar('#memoryGraph', data, memoryGraph_opt)
        .on('draw', function(data) {
            if(data.type === 'bar') {
                data.element.attr({
                    style: 'stroke-width: 12px'
                });
            };
        });;
    }
})

var cpuLoad_div = document.getElementById('cpuload');
socket.on('cpuLoad', function(data) {
    cpuLoad_div.innerHTML = 'CPU LOAD ' + data + ' %';
})

var coreGraph = 0;
var coreGraph_opt = {
    height: 250,
    high: 100,
    showArea: true,
    distributeSeries: true,
    axisY: {
        type: Chartist.FixedScaleAxis,
        onlyInteger: true,
        ticks: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
    },
    axisX: {
        labelInterpolationFnc: function(value) {
            return 'C' + value.match(/\d$/);
        }
    },
};
socket.on('coreGraph', function(data) {
    if (coreGraph) {
        coreGraph.update(data);
    } else {
        coreGraph = new Chartist.Bar('#coreGraph', data, coreGraph_opt,
        [// Options override for media > 800px
            ['screen and (min-width: 800px)', {
                height: 300,
                axisX: {
                    labelInterpolationFnc: Chartist.noop
                },
            }]
        ])
        .on('draw', function(plot) {
            if(plot.type === 'bar') {
                if( plot.seriesIndex%2 == 0 ){var color='#d70206'}
                else {var color='#f05b4f'}

                plot.element.attr({
                    style: 'stroke-width: ' + plot.axisX.axisLength/(2.5*data.series.length) + 'px;'
                    + 'stroke: ' + color
                });
            };
        });
    }
})

var netGraph;
var netGraph_opt = {
    height: 200,
    showArea: true,
    showPoint: false,
    lineSmooth: false,
    fullWidth: true,
    //lineSmooth: Chartist.Interpolation.step(),
    axisX: {
        showLabel: false,
    },
    axisY: {
        offset: 80,
        labelInterpolationFnc: function(value) {
            if (value > 1000000) {
                return value/1000000 + ' MB/s'
            } else if (value > 1000) {
                return value/1000 + ' KB/s'
            } else {
                return value + ' B/s'
            }
        },
    },
};
socket.on('netGraph', function(data) {
    if (netGraph) {
        netGraph.update(data);
    } else {
        netGraph = new Chartist.Line('#networkGraph', data, netGraph_opt);
    }
})

var conn_div = document.getElementById("connexions");
socket.on('netConns', function(data) {
    conn_div.innerHTML = 'TCP: ' + data.tcp + ' - UDP: ' + data.udp;
})

var diskGraph;
var diskGraph_opt= {
    high: 100,
    stackBars: true,
    seriesBarDistance: 1,
    height: 140,
    reverseData: true,
    horizontalBars: true,
    axisX: { showLabel: true,
        type: Chartist.FixedScaleAxis,
        onlyInteger: true,
        ticks: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100],
    },
    axisY: { offset: 55 }
};
socket.on('diskGraph', function(data) {
    if (diskGraph) {
        diskGraph.update(data);
    } else {
        diskGraph = new Chartist.Bar('#diskGraph', data, diskGraph_opt);
    }
})
