/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IntList;

public final class ByteCatchList
extends FixedSizeList {
    public static final ByteCatchList EMPTY = new ByteCatchList(0);

    public ByteCatchList(int n) {
        super(n);
    }

    public int byteLength() {
        return 2 + this.size() * 8;
    }

    public Item get(int n) {
        return (Item)this.get0(n);
    }

    public void set(int n, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n, item);
    }

    public void set(int n, int n2, int n3, int n4, CstType cstType) {
        this.set0(n, new Item(n2, n3, n4, cstType));
    }

    public ByteCatchList listFor(int n) {
        int n2 = this.size();
        Item[] itemArray = new Item[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Item item = this.get(i);
            if (!item.covers(n) || !ByteCatchList.typeNotFound(item, itemArray, n3)) continue;
            itemArray[n3] = item;
            ++n3;
        }
        if (n3 == 0) {
            return EMPTY;
        }
        ByteCatchList byteCatchList = new ByteCatchList(n3);
        for (int i = 0; i < n3; ++i) {
            byteCatchList.set(i, itemArray[i]);
        }
        byteCatchList.setImmutable();
        return byteCatchList;
    }

    private static boolean typeNotFound(Item item, Item[] itemArray, int n) {
        CstType cstType = item.getExceptionClass();
        for (int i = 0; i < n; ++i) {
            CstType cstType2 = itemArray[i].getExceptionClass();
            if (cstType2 != cstType && cstType2 != CstType.OBJECT) continue;
            return false;
        }
        return true;
    }

    public IntList toTargetList(int n) {
        if (n < -1) {
            throw new IllegalArgumentException("noException < -1");
        }
        boolean bl = n >= 0;
        int n2 = this.size();
        if (n2 == 0) {
            if (bl) {
                return IntList.makeImmutable(n);
            }
            return IntList.EMPTY;
        }
        IntList intList = new IntList(n2 + (bl ? 1 : 0));
        for (int i = 0; i < n2; ++i) {
            intList.add(this.get(i).getHandlerPc());
        }
        if (bl) {
            intList.add(n);
        }
        intList.setImmutable();
        return intList;
    }

    public TypeList toRopCatchList() {
        int n = this.size();
        if (n == 0) {
            return StdTypeList.EMPTY;
        }
        StdTypeList stdTypeList = new StdTypeList(n);
        for (int i = 0; i < n; ++i) {
            stdTypeList.set(i, this.get(i).getExceptionClass().getClassType());
        }
        stdTypeList.setImmutable();
        return stdTypeList;
    }

    public static class Item {
        private final int startPc;
        private final int endPc;
        private final int handlerPc;
        private final CstType exceptionClass;

        public Item(int n, int n2, int n3, CstType cstType) {
            if (n < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (n2 < n) {
                throw new IllegalArgumentException("endPc < startPc");
            }
            if (n3 < 0) {
                throw new IllegalArgumentException("handlerPc < 0");
            }
            this.startPc = n;
            this.endPc = n2;
            this.handlerPc = n3;
            this.exceptionClass = cstType;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getEndPc() {
            return this.endPc;
        }

        public int getHandlerPc() {
            return this.handlerPc;
        }

        public CstType getExceptionClass() {
            return this.exceptionClass != null ? this.exceptionClass : CstType.OBJECT;
        }

        public boolean covers(int n) {
            return n >= this.startPc && n < this.endPc;
        }
    }
}

