/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.Merger;
import com.android.dx.cf.code.SimException;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.util.ExceptionWithContext;
import com.android.dx.util.Hex;
import com.android.dx.util.MutabilityControl;

public final class ExecutionStack
extends MutabilityControl {
    private final TypeBearer[] stack;
    private final boolean[] local;
    private int stackPtr;

    public ExecutionStack(int n) {
        super(n != 0);
        this.stack = new TypeBearer[n];
        this.local = new boolean[n];
        this.stackPtr = 0;
    }

    public ExecutionStack copy() {
        ExecutionStack executionStack = new ExecutionStack(this.stack.length);
        System.arraycopy(this.stack, 0, executionStack.stack, 0, this.stack.length);
        System.arraycopy(this.local, 0, executionStack.local, 0, this.local.length);
        executionStack.stackPtr = this.stackPtr;
        return executionStack;
    }

    public void annotate(ExceptionWithContext exceptionWithContext) {
        int n = this.stackPtr - 1;
        for (int i = 0; i <= n; ++i) {
            String string = i == n ? "top0" : Hex.u2(n - i);
            exceptionWithContext.addContext("stack[" + string + "]: " + ExecutionStack.stackElementString(this.stack[i]));
        }
    }

    public void makeInitialized(Type type) {
        if (this.stackPtr == 0) {
            return;
        }
        this.throwIfImmutable();
        Type type2 = type.getInitializedType();
        for (int i = 0; i < this.stackPtr; ++i) {
            if (this.stack[i] != type) continue;
            this.stack[i] = type2;
        }
    }

    public int getMaxStack() {
        return this.stack.length;
    }

    public int size() {
        return this.stackPtr;
    }

    public void clear() {
        this.throwIfImmutable();
        for (int i = 0; i < this.stackPtr; ++i) {
            this.stack[i] = null;
            this.local[i] = false;
        }
        this.stackPtr = 0;
    }

    public void push(TypeBearer typeBearer) {
        int n;
        this.throwIfImmutable();
        try {
            typeBearer = typeBearer.getFrameType();
            n = typeBearer.getType().getCategory();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("type == null");
        }
        if (this.stackPtr + n > this.stack.length) {
            ExecutionStack.throwSimException("overflow");
            return;
        }
        if (n == 2) {
            this.stack[this.stackPtr] = null;
            ++this.stackPtr;
        }
        this.stack[this.stackPtr] = typeBearer;
        ++this.stackPtr;
    }

    public void setLocal() {
        this.throwIfImmutable();
        this.local[this.stackPtr] = true;
    }

    public TypeBearer peek(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n >= this.stackPtr) {
            return ExecutionStack.throwSimException("underflow");
        }
        return this.stack[this.stackPtr - n - 1];
    }

    public boolean peekLocal(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n >= this.stackPtr) {
            throw new SimException("stack: underflow");
        }
        return this.local[this.stackPtr - n - 1];
    }

    public Type peekType(int n) {
        return this.peek(n).getType();
    }

    public TypeBearer pop() {
        this.throwIfImmutable();
        TypeBearer typeBearer = this.peek(0);
        this.stack[this.stackPtr - 1] = null;
        this.local[this.stackPtr - 1] = false;
        this.stackPtr -= typeBearer.getType().getCategory();
        return typeBearer;
    }

    public void change(int n, TypeBearer typeBearer) {
        this.throwIfImmutable();
        try {
            typeBearer = typeBearer.getFrameType();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("type == null");
        }
        int n2 = this.stackPtr - n - 1;
        TypeBearer typeBearer2 = this.stack[n2];
        if (typeBearer2 == null || typeBearer2.getType().getCategory() != typeBearer.getType().getCategory()) {
            ExecutionStack.throwSimException("incompatible substitution: " + ExecutionStack.stackElementString(typeBearer2) + " -> " + ExecutionStack.stackElementString(typeBearer));
        }
        this.stack[n2] = typeBearer;
    }

    public ExecutionStack merge(ExecutionStack executionStack) {
        try {
            return Merger.mergeStack(this, executionStack);
        }
        catch (SimException simException) {
            simException.addContext("underlay stack:");
            this.annotate(simException);
            simException.addContext("overlay stack:");
            executionStack.annotate(simException);
            throw simException;
        }
    }

    private static String stackElementString(TypeBearer typeBearer) {
        if (typeBearer == null) {
            return "<invalid>";
        }
        return typeBearer.toString();
    }

    private static TypeBearer throwSimException(String string) {
        throw new SimException("stack: " + string);
    }
}

