/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.code.DalvCode;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.dex.code.LocalList;
import com.android.dx.dex.code.PositionList;
import com.android.dx.dex.file.DebugInfoEncoder;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.ExceptionWithContext;
import java.io.PrintWriter;

public class DebugInfoItem
extends OffsettedItem {
    private static final int ALIGNMENT = 1;
    private static final boolean ENABLE_ENCODER_SELF_CHECK = false;
    private final DalvCode code;
    private byte[] encoded;
    private final boolean isStatic;
    private final CstMethodRef ref;

    public DebugInfoItem(DalvCode dalvCode, boolean bl, CstMethodRef cstMethodRef) {
        super(1, -1);
        if (dalvCode == null) {
            throw new NullPointerException("code == null");
        }
        this.code = dalvCode;
        this.isStatic = bl;
        this.ref = cstMethodRef;
    }

    public ItemType itemType() {
        return ItemType.TYPE_DEBUG_INFO_ITEM;
    }

    public void addContents(DexFile dexFile) {
    }

    protected void place0(Section section, int n) {
        try {
            this.encoded = this.encode(section.getFile(), null, null, null, false);
            this.setWriteSize(this.encoded.length);
        }
        catch (RuntimeException runtimeException) {
            throw ExceptionWithContext.withContext(runtimeException, "...while placing debug info for " + this.ref.toHuman());
        }
    }

    public String toHuman() {
        throw new RuntimeException("unsupported");
    }

    public void annotateTo(DexFile dexFile, AnnotatedOutput annotatedOutput, String string) {
        this.encode(dexFile, string, null, annotatedOutput, false);
    }

    public void debugPrint(PrintWriter printWriter, String string) {
        this.encode(null, string, printWriter, null, false);
    }

    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(this.offsetString() + " debug info");
            this.encode(dexFile, null, null, annotatedOutput, true);
        }
        annotatedOutput.write(this.encoded);
    }

    private byte[] encode(DexFile dexFile, String string, PrintWriter printWriter, AnnotatedOutput annotatedOutput, boolean bl) {
        byte[] byArray = this.encode0(dexFile, string, printWriter, annotatedOutput, bl);
        return byArray;
    }

    private byte[] encode0(DexFile dexFile, String string, PrintWriter printWriter, AnnotatedOutput annotatedOutput, boolean bl) {
        PositionList positionList = this.code.getPositions();
        LocalList localList = this.code.getLocals();
        DalvInsnList dalvInsnList = this.code.getInsns();
        int n = dalvInsnList.codeSize();
        int n2 = dalvInsnList.getRegistersSize();
        DebugInfoEncoder debugInfoEncoder = new DebugInfoEncoder(positionList, localList, dexFile, n, n2, this.isStatic, this.ref);
        byte[] byArray = printWriter == null && annotatedOutput == null ? debugInfoEncoder.convert() : debugInfoEncoder.convertAndAnnotate(string, printWriter, annotatedOutput, bl);
        return byArray;
    }
}

