/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;

public final class DexHasher {
    private static final int CHECKSUM_OFFSET = 8;
    private static final int CHECKSUM_SIZE = 4;
    private static final int SIGNATURE_OFFSET = 12;
    private static final int SIGNATURE_SIZE = 20;

    public byte[] computeSignature(DexBuffer dexBuffer) throws IOException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        int n = 32;
        byte[] byArray = dexBuffer.getBytes();
        messageDigest.update(byArray, n, byArray.length - n);
        return messageDigest.digest();
    }

    public int computeChecksum(DexBuffer dexBuffer) throws IOException {
        Adler32 adler32 = new Adler32();
        int n = 12;
        byte[] byArray = dexBuffer.getBytes();
        adler32.update(byArray, n, byArray.length - n);
        return (int)adler32.getValue();
    }

    public void writeHashes(DexBuffer dexBuffer) throws IOException {
        byte[] byArray = this.computeSignature(dexBuffer);
        dexBuffer.open(12).write(byArray);
        int n = this.computeChecksum(dexBuffer);
        dexBuffer.open(8).writeInt(n);
    }
}

