/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.annotation;

import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.cst.CstType;
import com.android.dx.util.MutabilityControl;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Annotations
extends MutabilityControl
implements Comparable<Annotations> {
    public static final Annotations EMPTY = new Annotations();
    private final TreeMap<CstType, Annotation> annotations = new TreeMap();

    public static Annotations combine(Annotations annotations, Annotations annotations2) {
        Annotations annotations3 = new Annotations();
        annotations3.addAll(annotations);
        annotations3.addAll(annotations2);
        annotations3.setImmutable();
        return annotations3;
    }

    public static Annotations combine(Annotations annotations, Annotation annotation) {
        Annotations annotations2 = new Annotations();
        annotations2.addAll(annotations);
        annotations2.add(annotation);
        annotations2.setImmutable();
        return annotations2;
    }

    public int hashCode() {
        return this.annotations.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Annotations)) {
            return false;
        }
        Annotations annotations = (Annotations)object;
        return this.annotations.equals(annotations.annotations);
    }

    @Override
    public int compareTo(Annotations annotations) {
        Iterator<Annotation> iterator = this.annotations.values().iterator();
        Iterator<Annotation> iterator2 = annotations.annotations.values().iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            Annotation annotation;
            Annotation annotation2 = iterator.next();
            int n = annotation2.compareTo(annotation = iterator2.next());
            if (n == 0) continue;
            return n;
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        stringBuilder.append("annotations{");
        for (Annotation annotation : this.annotations.values()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(annotation.toHuman());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int size() {
        return this.annotations.size();
    }

    public void add(Annotation annotation) {
        this.throwIfImmutable();
        if (annotation == null) {
            throw new NullPointerException("annotation == null");
        }
        CstType cstType = annotation.getType();
        if (this.annotations.containsKey(cstType)) {
            throw new IllegalArgumentException("duplicate type: " + cstType.toHuman());
        }
        this.annotations.put(cstType, annotation);
    }

    public void addAll(Annotations annotations) {
        this.throwIfImmutable();
        if (annotations == null) {
            throw new NullPointerException("toAdd == null");
        }
        for (Annotation annotation : annotations.annotations.values()) {
            this.add(annotation);
        }
    }

    public Collection<Annotation> getAnnotations() {
        return Collections.unmodifiableCollection(this.annotations.values());
    }

    static {
        EMPTY.setImmutable();
    }
}

