/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.RegOps;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.Hex;

public final class Rop {
    public static final int BRANCH_MIN = 1;
    public static final int BRANCH_NONE = 1;
    public static final int BRANCH_RETURN = 2;
    public static final int BRANCH_GOTO = 3;
    public static final int BRANCH_IF = 4;
    public static final int BRANCH_SWITCH = 5;
    public static final int BRANCH_THROW = 6;
    public static final int BRANCH_MAX = 6;
    private final int opcode;
    private final Type result;
    private final TypeList sources;
    private final TypeList exceptions;
    private final int branchingness;
    private final boolean isCallLike;
    private final String nickname;

    public Rop(int n, Type type, TypeList typeList, TypeList typeList2, int n2, boolean bl, String string) {
        if (type == null) {
            throw new NullPointerException("result == null");
        }
        if (typeList == null) {
            throw new NullPointerException("sources == null");
        }
        if (typeList2 == null) {
            throw new NullPointerException("exceptions == null");
        }
        if (n2 < 1 || n2 > 6) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (typeList2.size() != 0 && n2 != 6) {
            throw new IllegalArgumentException("exceptions / branchingness mismatch");
        }
        this.opcode = n;
        this.result = type;
        this.sources = typeList;
        this.exceptions = typeList2;
        this.branchingness = n2;
        this.isCallLike = bl;
        this.nickname = string;
    }

    public Rop(int n, Type type, TypeList typeList, TypeList typeList2, int n2, String string) {
        this(n, type, typeList, typeList2, n2, false, string);
    }

    public Rop(int n, Type type, TypeList typeList, int n2, String string) {
        this(n, type, typeList, StdTypeList.EMPTY, n2, false, string);
    }

    public Rop(int n, Type type, TypeList typeList, String string) {
        this(n, type, typeList, StdTypeList.EMPTY, 1, false, string);
    }

    public Rop(int n, Type type, TypeList typeList, TypeList typeList2, String string) {
        this(n, type, typeList, typeList2, 6, false, string);
    }

    public Rop(int n, TypeList typeList, TypeList typeList2) {
        this(n, Type.VOID, typeList, typeList2, 6, true, null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rop)) {
            return false;
        }
        Rop rop = (Rop)object;
        return this.opcode == rop.opcode && this.branchingness == rop.branchingness && this.result == rop.result && this.sources.equals(rop.sources) && this.exceptions.equals(rop.exceptions);
    }

    public int hashCode() {
        int n = this.opcode * 31 + this.branchingness;
        n = n * 31 + this.result.hashCode();
        n = n * 31 + this.sources.hashCode();
        n = n * 31 + this.exceptions.hashCode();
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("Rop{");
        stringBuffer.append(RegOps.opName(this.opcode));
        if (this.result != Type.VOID) {
            stringBuffer.append(" ");
            stringBuffer.append(this.result);
        } else {
            stringBuffer.append(" .");
        }
        stringBuffer.append(" <-");
        int n2 = this.sources.size();
        if (n2 == 0) {
            stringBuffer.append(" .");
        } else {
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
                stringBuffer.append(this.sources.getType(n));
            }
        }
        if (this.isCallLike) {
            stringBuffer.append(" call");
        }
        if ((n2 = this.exceptions.size()) != 0) {
            stringBuffer.append(" throws");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
                Type type = this.exceptions.getType(n);
                if (type == Type.THROWABLE) {
                    stringBuffer.append("<any>");
                    continue;
                }
                stringBuffer.append(this.exceptions.getType(n));
            }
        } else {
            switch (this.branchingness) {
                case 1: {
                    stringBuffer.append(" flows");
                    break;
                }
                case 2: {
                    stringBuffer.append(" returns");
                    break;
                }
                case 3: {
                    stringBuffer.append(" gotos");
                    break;
                }
                case 4: {
                    stringBuffer.append(" ifs");
                    break;
                }
                case 5: {
                    stringBuffer.append(" switches");
                    break;
                }
                default: {
                    stringBuffer.append(" " + Hex.u1(this.branchingness));
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Type getResult() {
        return this.result;
    }

    public TypeList getSources() {
        return this.sources;
    }

    public TypeList getExceptions() {
        return this.exceptions;
    }

    public int getBranchingness() {
        return this.branchingness;
    }

    public boolean isCallLike() {
        return this.isCallLike;
    }

    public boolean isCommutative() {
        switch (this.opcode) {
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    public String getNickname() {
        if (this.nickname != null) {
            return this.nickname;
        }
        return this.toString();
    }

    public final boolean canThrow() {
        return this.exceptions.size() != 0;
    }
}

