/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dx.rop.cst.CstLiteral32;
import com.android.dx.rop.type.Type;
import com.android.dx.util.Hex;

public final class CstChar
extends CstLiteral32 {
    public static final CstChar VALUE_0 = CstChar.make('\u0000');

    public static CstChar make(char c) {
        return new CstChar(c);
    }

    public static CstChar make(int n) {
        char c = (char)n;
        if (c != n) {
            throw new IllegalArgumentException("bogus char value: " + n);
        }
        return CstChar.make(c);
    }

    private CstChar(char c) {
        super(c);
    }

    public String toString() {
        int n = this.getIntBits();
        return "char{0x" + Hex.u2(n) + " / " + n + '}';
    }

    public Type getType() {
        return Type.CHAR;
    }

    public String typeName() {
        return "char";
    }

    public String toHuman() {
        return Integer.toString(this.getIntBits());
    }

    public char getValue() {
        return (char)this.getIntBits();
    }
}

