/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.PlainCstInsn;
import com.android.dx.rop.code.PlainInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.Rop;
import com.android.dx.rop.code.Rops;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.code.ThrowingCstInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstCollector {
    private static final int MAX_COLLECTED_CONSTANTS = 5;
    private static boolean COLLECT_STRINGS = false;
    private static boolean COLLECT_ONE_LOCAL = false;
    private final SsaMethod ssaMeth;

    public static void process(SsaMethod ssaMethod) {
        ConstCollector constCollector = new ConstCollector(ssaMethod);
        constCollector.run();
    }

    private ConstCollector(SsaMethod ssaMethod) {
        this.ssaMeth = ssaMethod;
    }

    private void run() {
        int n = this.ssaMeth.getRegCount();
        ArrayList<TypedConstant> arrayList = this.getConstsSortedByCountUse();
        int n2 = Math.min(arrayList.size(), 5);
        SsaBasicBlock ssaBasicBlock = this.ssaMeth.getEntryBlock();
        HashMap<TypedConstant, RegisterSpec> hashMap = new HashMap<TypedConstant, RegisterSpec>(n2);
        for (int i = 0; i < n2; ++i) {
            TypedConstant typedConstant = arrayList.get(i);
            RegisterSpec registerSpec = RegisterSpec.make(this.ssaMeth.makeNewSsaReg(), typedConstant);
            Rop rop = Rops.opConst(typedConstant);
            if (rop.getBranchingness() == 1) {
                ssaBasicBlock.addInsnToHead(new PlainCstInsn(Rops.opConst(typedConstant), SourcePosition.NO_INFO, registerSpec, RegisterSpecList.EMPTY, typedConstant));
            } else {
                SsaBasicBlock ssaBasicBlock2 = this.ssaMeth.getEntryBlock();
                SsaBasicBlock ssaBasicBlock3 = ssaBasicBlock2.getPrimarySuccessor();
                SsaBasicBlock ssaBasicBlock4 = ssaBasicBlock2.insertNewSuccessor(ssaBasicBlock3);
                ssaBasicBlock4.replaceLastInsn(new ThrowingCstInsn(rop, SourcePosition.NO_INFO, RegisterSpecList.EMPTY, StdTypeList.EMPTY, (Constant)typedConstant));
                SsaBasicBlock ssaBasicBlock5 = ssaBasicBlock4.insertNewSuccessor(ssaBasicBlock3);
                PlainInsn plainInsn = new PlainInsn(Rops.opMoveResultPseudo(registerSpec.getTypeBearer()), SourcePosition.NO_INFO, registerSpec, RegisterSpecList.EMPTY);
                ssaBasicBlock5.addInsnToHead(plainInsn);
            }
            hashMap.put(typedConstant, registerSpec);
        }
        this.updateConstUses(hashMap, n);
    }

    private ArrayList<TypedConstant> getConstsSortedByCountUse() {
        int n = this.ssaMeth.getRegCount();
        final HashMap<TypedConstant, Integer> hashMap = new HashMap<TypedConstant, Integer>();
        HashSet<TypedConstant> hashSet = new HashSet<TypedConstant>();
        for (int i = 0; i < n; ++i) {
            Integer n2;
            RegisterSpec object;
            TypeBearer typeBearer;
            Object object2 = this.ssaMeth.getDefinitionForRegister(i);
            if (object2 == null || ((SsaInsn)object2).getOpcode() == null || !(typeBearer = (object = ((SsaInsn)object2).getResult()).getTypeBearer()).isConstant()) continue;
            TypedConstant typedConstant = (TypedConstant)typeBearer;
            if (((SsaInsn)object2).getOpcode().getOpcode() == 56) {
                int n3 = ((SsaInsn)object2).getBlock().getPredecessors().nextSetBit(0);
                ArrayList<SsaInsn> arrayList = this.ssaMeth.getBlocks().get(n3).getInsns();
                object2 = arrayList.get(arrayList.size() - 1);
            }
            if (((SsaInsn)object2).canThrow() && (!(typedConstant instanceof CstString) || !COLLECT_STRINGS || ((SsaInsn)object2).getBlock().getSuccessors().cardinality() > 1)) continue;
            if (this.ssaMeth.isRegALocal(object)) {
                if (!COLLECT_ONE_LOCAL || hashSet.contains(typedConstant)) continue;
                hashSet.add(typedConstant);
            }
            if ((n2 = (Integer)hashMap.get(typedConstant)) == null) {
                hashMap.put(typedConstant, 1);
                continue;
            }
            hashMap.put(typedConstant, n2 + 1);
        }
        ArrayList<TypedConstant> arrayList = new ArrayList<TypedConstant>();
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            arrayList.add((TypedConstant)entry.getKey());
        }
        Collections.sort(arrayList, new Comparator<Constant>(){

            @Override
            public int compare(Constant constant, Constant constant2) {
                int n = (Integer)hashMap.get(constant2) - (Integer)hashMap.get(constant);
                if (n == 0) {
                    n = constant.compareTo(constant2);
                }
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        return arrayList;
    }

    private void fixLocalAssignment(RegisterSpec registerSpec, RegisterSpec registerSpec2) {
        for (SsaInsn ssaInsn : this.ssaMeth.getUseListForRegister(registerSpec.getReg())) {
            RegisterSpec registerSpec3 = ssaInsn.getLocalAssignment();
            if (registerSpec3 == null || ssaInsn.getResult() == null) continue;
            LocalItem localItem = registerSpec3.getLocalItem();
            ssaInsn.setResultLocal(null);
            registerSpec2 = registerSpec2.withLocalItem(localItem);
            SsaInsn ssaInsn2 = SsaInsn.makeFromRop(new PlainInsn(Rops.opMarkLocal(registerSpec2), SourcePosition.NO_INFO, null, RegisterSpecList.make(registerSpec2)), ssaInsn.getBlock());
            ArrayList<SsaInsn> arrayList = ssaInsn.getBlock().getInsns();
            arrayList.add(arrayList.indexOf(ssaInsn) + 1, ssaInsn2);
        }
    }

    private void updateConstUses(HashMap<TypedConstant, RegisterSpec> hashMap, int n) {
        HashSet<TypedConstant> hashSet = new HashSet<TypedConstant>();
        ArrayList<SsaInsn>[] arrayListArray = this.ssaMeth.getUseListCopy();
        for (int i = 0; i < n; ++i) {
            TypedConstant typedConstant;
            RegisterSpec registerSpec;
            SsaInsn ssaInsn = this.ssaMeth.getDefinitionForRegister(i);
            if (ssaInsn == null) continue;
            final RegisterSpec registerSpec2 = ssaInsn.getResult();
            TypeBearer typeBearer = ssaInsn.getResult().getTypeBearer();
            if (!typeBearer.isConstant() || (registerSpec = hashMap.get(typedConstant = (TypedConstant)typeBearer)) == null) continue;
            if (this.ssaMeth.isRegALocal(registerSpec2)) {
                if (!COLLECT_ONE_LOCAL || hashSet.contains(typedConstant)) continue;
                hashSet.add(typedConstant);
                this.fixLocalAssignment(registerSpec2, hashMap.get(typedConstant));
            }
            RegisterMapper registerMapper = new RegisterMapper(){

                public int getNewRegisterCount() {
                    return ConstCollector.this.ssaMeth.getRegCount();
                }

                public RegisterSpec map(RegisterSpec registerSpec3) {
                    if (registerSpec3.getReg() == registerSpec2.getReg()) {
                        return registerSpec.withLocalItem(registerSpec3.getLocalItem());
                    }
                    return registerSpec3;
                }
            };
            for (SsaInsn ssaInsn2 : arrayListArray[registerSpec2.getReg()]) {
                if (ssaInsn2.canThrow() && ssaInsn2.getBlock().getSuccessors().cardinality() > 1) continue;
                ssaInsn2.mapSourceRegisters(registerMapper);
            }
        }
    }
}

