/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.ssa.DomFront;
import com.android.dx.ssa.LocalVariableExtractor;
import com.android.dx.ssa.LocalVariableInfo;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.SsaRenamer;
import com.android.dx.util.IntIterator;
import java.util.ArrayList;
import java.util.BitSet;

public class SsaConverter {
    public static final boolean DEBUG = false;

    public static SsaMethod convertToSsaMethod(RopMethod ropMethod, int n, boolean bl) {
        SsaMethod ssaMethod = SsaMethod.newFromRopMethod(ropMethod, n, bl);
        SsaConverter.edgeSplit(ssaMethod);
        LocalVariableInfo localVariableInfo = LocalVariableExtractor.extract(ssaMethod);
        SsaConverter.placePhiFunctions(ssaMethod, localVariableInfo, 0);
        new SsaRenamer(ssaMethod).run();
        ssaMethod.makeExitBlock();
        return ssaMethod;
    }

    public static void updateSsaMethod(SsaMethod ssaMethod, int n) {
        LocalVariableInfo localVariableInfo = LocalVariableExtractor.extract(ssaMethod);
        SsaConverter.placePhiFunctions(ssaMethod, localVariableInfo, n);
        new SsaRenamer(ssaMethod, n).run();
    }

    public static SsaMethod testEdgeSplit(RopMethod ropMethod, int n, boolean bl) {
        SsaMethod ssaMethod = SsaMethod.newFromRopMethod(ropMethod, n, bl);
        SsaConverter.edgeSplit(ssaMethod);
        return ssaMethod;
    }

    public static SsaMethod testPhiPlacement(RopMethod ropMethod, int n, boolean bl) {
        SsaMethod ssaMethod = SsaMethod.newFromRopMethod(ropMethod, n, bl);
        SsaConverter.edgeSplit(ssaMethod);
        LocalVariableInfo localVariableInfo = LocalVariableExtractor.extract(ssaMethod);
        SsaConverter.placePhiFunctions(ssaMethod, localVariableInfo, 0);
        return ssaMethod;
    }

    private static void edgeSplit(SsaMethod ssaMethod) {
        SsaConverter.edgeSplitPredecessors(ssaMethod);
        SsaConverter.edgeSplitMoveExceptionsAndResults(ssaMethod);
        SsaConverter.edgeSplitSuccessors(ssaMethod);
    }

    private static void edgeSplitPredecessors(SsaMethod ssaMethod) {
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SsaBasicBlock ssaBasicBlock = arrayList.get(i);
            if (!SsaConverter.nodeNeedsUniquePredecessor(ssaBasicBlock)) continue;
            ssaBasicBlock.insertNewPredecessor();
        }
    }

    private static boolean nodeNeedsUniquePredecessor(SsaBasicBlock ssaBasicBlock) {
        int n = ssaBasicBlock.getPredecessors().cardinality();
        int n2 = ssaBasicBlock.getSuccessors().cardinality();
        return n > 1 && n2 > 1;
    }

    private static void edgeSplitMoveExceptionsAndResults(SsaMethod ssaMethod) {
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SsaBasicBlock ssaBasicBlock = arrayList.get(i);
            if (ssaBasicBlock.isExitBlock() || ssaBasicBlock.getPredecessors().cardinality() <= 1 || !ssaBasicBlock.getInsns().get(0).isMoveException()) continue;
            BitSet bitSet = (BitSet)ssaBasicBlock.getPredecessors().clone();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                SsaBasicBlock ssaBasicBlock2 = arrayList.get(n);
                SsaBasicBlock ssaBasicBlock3 = ssaBasicBlock2.insertNewSuccessor(ssaBasicBlock);
                ssaBasicBlock3.getInsns().add(0, ssaBasicBlock.getInsns().get(0).clone());
                n = bitSet.nextSetBit(n + 1);
            }
            ssaBasicBlock.getInsns().remove(0);
        }
    }

    private static void edgeSplitSuccessors(SsaMethod ssaMethod) {
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SsaBasicBlock ssaBasicBlock = arrayList.get(i);
            BitSet bitSet = (BitSet)ssaBasicBlock.getSuccessors().clone();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                SsaBasicBlock ssaBasicBlock2 = arrayList.get(n);
                if (SsaConverter.needsNewSuccessor(ssaBasicBlock, ssaBasicBlock2)) {
                    ssaBasicBlock.insertNewSuccessor(ssaBasicBlock2);
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    private static boolean needsNewSuccessor(SsaBasicBlock ssaBasicBlock, SsaBasicBlock ssaBasicBlock2) {
        ArrayList<SsaInsn> arrayList = ssaBasicBlock.getInsns();
        SsaInsn ssaInsn = arrayList.get(arrayList.size() - 1);
        return (ssaInsn.getResult() != null || ssaInsn.getSources().size() > 0) && ssaBasicBlock2.getPredecessors().cardinality() > 1;
    }

    private static void placePhiFunctions(SsaMethod ssaMethod, LocalVariableInfo localVariableInfo, int n) {
        int n2;
        ArrayList<SsaBasicBlock> arrayList = ssaMethod.getBlocks();
        int n3 = arrayList.size();
        int n4 = ssaMethod.getRegCount() - n;
        DomFront domFront = new DomFront(ssaMethod);
        DomFront.DomInfo[] domInfoArray = domFront.run();
        BitSet[] bitSetArray = new BitSet[n4];
        BitSet[] bitSetArray2 = new BitSet[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            bitSetArray[n2] = new BitSet(n3);
            bitSetArray2[n2] = new BitSet(n3);
        }
        int n5 = arrayList.size();
        for (n2 = 0; n2 < n5; ++n2) {
            SsaBasicBlock ssaBasicBlock = arrayList.get(n2);
            for (SsaInsn object : ssaBasicBlock.getInsns()) {
                RegisterSpec registerSpec = object.getResult();
                if (registerSpec == null || registerSpec.getReg() - n < 0) continue;
                bitSetArray[registerSpec.getReg() - n].set(n2);
            }
        }
        int n6 = n4;
        for (n5 = 0; n5 < n6; ++n5) {
            int n7;
            BitSet bitSet = (BitSet)bitSetArray[n5].clone();
            while (0 <= (n7 = bitSet.nextSetBit(0))) {
                bitSet.clear(n7);
                IntIterator intIterator = domInfoArray[n7].dominanceFrontiers.iterator();
                while (intIterator.hasNext()) {
                    int n8 = intIterator.next();
                    if (bitSetArray2[n5].get(n8)) continue;
                    bitSetArray2[n5].set(n8);
                    int n9 = n5 + n;
                    RegisterSpec registerSpec = localVariableInfo.getStarts(n8).get(n9);
                    if (registerSpec == null) {
                        arrayList.get(n8).addPhiInsnForReg(n9);
                    } else {
                        arrayList.get(n8).addPhiInsnForReg(registerSpec);
                    }
                    if (bitSetArray[n5].get(n8)) continue;
                    bitSet.set(n8);
                }
            }
        }
    }
}

